Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[hatchery.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission6.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 20.0,
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = false,        --Do captures halve defensive strength?
		DisableLockdown = false,        --Turn off emergency help is player is behind
		NoAdvance       = false,        --Do not allow player to capture points
		HiveCtrAttack   = false,        --Send alien spawn to undefended alien hives
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		    [[ZU_DEF_SPITTERS]],
		    [[ZU_NONE]],
		    [[ZU_NONE]],
		    [[ZU_NONE]],
            [[ZU_SPAWN_SPITTERS]],
            [[ZU_NONE]],
            [[ZU_BONE_SHIELD]],   
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[inactive]],
		--FreeUpgradesDefault = [[active]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	GetLevelProgress = function ()
        
        local progress = math.min(1.0, (nextSargeTeamWaypontIndex + nextDocTeamWaypontIndex - 2)/10)
        
		return progress --math.pow(progress, 1.5)
		
	end,
		
	OnDebugCall = function (mousePos)

		--StartNextSargeAttack()
		--StartNextDocAttack()
		
		currentTimer:ResetTimer(3000)
		
	end
}

currentTimer = nil

pathMarkers = {}
function CreatePathMarker(p_sourceId, p_waypointId)

    local waypoint = GameWorld:GetEntityById(p_waypointId)		
    local marine = GameWorld:GetEntityById(p_sourceId)
    
    local ent = nil
    if waypoint and marine then
        ent = GameWorld:CreatePathMarker(marine:GetPos(), waypoint:GetPos())   
        pathMarkers[p_waypointId] = ent:GetHandle()
    end
    
    return ent
end

function RemovePathMarker(p_waypointId)

    local entHandle = pathMarkers[p_waypointId]
    if not entHandle then
        return
    end
    
    local pathMarker = entHandle:GetPtr()
    if not pathMarker then
        return
    end
    
    pathMarker:Kill()
    GameWorld:RemoveTrainingArrow(p_waypointId)

end

function MakeHero(p_marineId)

    local entity = GameWorld:GetEntityById(p_marineId)
    if not entity then
        return
    end
    
    local marine = entity:ToCHuman()
    if not marine then
        return
    end
    
    marine:MakeHero()

end

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		

        PlacePropCrates()
	
		LevelUtils.ShowTimedDialogue("Do you really think that you can go hide in some dark corner Drake?\n\nStay and fight, damn you.", "Scout")

        --LossCondition:Enable()
        --KillBossObjective:Enable()

        --TeamDropScript:Enable()

        GameWorld:AddObjective("sargeObj", "Protect the sargeant")
        GameWorld:AddObjective("docObj", "Protect the doctor")

        GameWorld:CreateTrainingArrow("sargeTeam1",   "PNT_PORTRAIT_SARGE") 
        GameWorld:CreateTrainingArrow("docTeam1",     "PNT_PORTRAIT_SCOUT")

        MakeHero("sargeTeam1")
        MakeHero("docTeam1")

        CreatePathMarker("sargeTeam1", "sargeWaypoint" .. nextSargeTeamWaypontIndex)
        ScriptMgr:DoDelayedCall(5000,
            function()
                OnSargeAttackTriggered()
            end)
            
		self:Disable()
	end)
LevelInit:Enable()

nextSargeTeamWaypontIndex = 1
sargeTeamIds = {"sargeTeam1", "sargeTeam2", "sargeTeam3", "sargeTeam4", "sargeTeam5", "sargeTeam6"}

nextDocTeamWaypontIndex = 1
docTeamIds = {"docTeam1", "docTeam2", "docTeam3"}

function OrderMarineCommand(p_marineId, p_waypointIdArray, p_offset, p_command)

    local marine = GameWorld:GetEntityById(p_marineId)
    if not marine then
        return
    end
    
    local human = marine:ToCHuman()
    if not human then
        return
    end    
    
    for i=1, #p_waypointIdArray do
        local waypointId = p_waypointIdArray[i]
        local waypoint = GameWorld:GetEntityById(waypointId)
        
        if waypoint then
            human:SendCommand(p_command, waypoint:GetPos() + p_offset, nil, true)
        end
        
    end

end

function OrderMarineAssault(p_marineId, p_waypointIdArray, p_offset)
    OrderMarineCommand(p_marineId, p_waypointIdArray, p_offset, ICommandable.CT_ATTACKMOVE)
end

function OrderMarineMove(p_marineId, p_waypointIdArray, p_offset)
    OrderMarineCommand(p_marineId, p_waypointIdArray, p_offset, ICommandable.CT_MOVE)
end

sargeBusy = false

function StartNextSargeAttack()

    local waypointId = "sargeWaypoint" .. nextSargeTeamWaypontIndex
    local waypoint = GameWorld:GetEntityById(waypointId)

    if not waypoint then
        return
    end
    
    GameWorld:CreateTrainingArrow(waypointId)
    GameWorld:MakeAnnouncement("SARGEANT\nATTACKING")
    
    sargeBusy = true
    
    for i=1, #sargeTeamIds do
        local offsetDelta = vect2f.MakePolar(GetRandomRangeInt(3.0, 4.0), i/#sargeTeamIds*math.pi*2)
        
        OrderMarineAssault(sargeTeamIds[i], {waypointId}, offsetDelta)

    end

    if nextSargeTeamWaypontIndex == 1 then
        LevelUtils.ShowTimedDialogue("To hell with this.\n\nI'm getting my Devils off of this bloody rock.\nI don't do heroics - look where it got the general.", "Sarge")
    end


    nextSargeTeamWaypontIndex = nextSargeTeamWaypontIndex + 1
    
end

function OnSargeAttackTriggered()

    StartNextSargeAttack()
    
    local timerleft = 90000
    local checkDelay = 500
    
    if nextDocTeamWaypontIndex >= 5 then
        timerleft = 20000
    end
    
    ScriptMgr:DoDelayedCall(checkDelay,
        function()
            
            if not docBusy then
                currentTimer = LevelUtils.CreateTimer(timerleft, "Next Doc Attack in %s", function() GameWorld:SetEventIndicator(""); OnDocAttackTriggered() end) 
                CreatePathMarker("docTeam1", "docCrate" .. nextDocTeamWaypontIndex)      
            else
                timerleft = math.max(timerleft - checkDelay, 3000)
            end
            
            return docBusy
            
        end)
    
end

propCrateHandles = {}
function PlacePropCrates()

    for i=1,10000 do
    
        local waypointId = "docWaypoint" .. i
        local waypoint = GameWorld:GetEntityById(waypointId)
        
        if not waypoint then
            break
        end        
        
        local crate = GameWorld:CreateEntity("PropCrate", "docCrate" .. i, waypoint:GetPos() )
        propCrateHandles[i] = crate:GetHandle()
    end
    
end

function RespawnDocMarines()

    local waypointId = "marineSpawn"
    local waypoint = GameWorld:GetEntityById(waypointId)

    if not waypoint then
        return
    end

    for i=1, #docTeamIds do
        local marineId = docTeamIds[i]
        local ent = GameWorld:GetEntityById(marineId)
        local offsetDelta = vect2f.MakePolar(GetRandomRangeInt(3.0, 4.0), i/#docTeamIds*math.pi*2)

        if not ent then
            local marine = GameWorld:CreateEntity("AIMarine", marineId, waypoint:GetPos() + offsetDelta)
            OrderMarineAssault(marineId, {"docWaypoint0"}, offsetDelta)
        end

    end

end

local trackingCrateHandle = nil
local trackingMarineHandle = nil

function PropCrateUpdateScript(p_milliseconds)
    
    if not trackingCrateHandle or not trackingMarineHandle then
        return
    end
    
    local crateEnt = trackingCrateHandle:GetPtr()
    local marineEnt = trackingMarineHandle:GetPtr()
    local destEnt = GameWorld:GetEntityById("docWaypoint0")
    
    if not crateEnt then
        return
    end
 
    crateEnt = crateEnt:ToCPropCrate()
    if not crateEnt then
        return
    end
    
    local crateAttached = crateEnt:GetAttachedActivator() ~= nil
   
    if marineEnt and not crateAttached and vect2f.IsDistLess(crateEnt:GetPos(), marineEnt:GetPos(), 5.0) then
        crateEnt:AttachTo(marineEnt)
        
        ReturnDocTeamToBase()        
    end
    
    if destEnt and crateAttached and vect2f.IsDistLess(crateEnt:GetPos(), destEnt:GetPos(), 10.0) then
        RemovePathMarker(crateEnt:GetId())
        GameWorld:AwardBuildPoints(3, crateEnt:GetPos())
        crateEnt:Kill()
        docBusy = false
        
        RespawnDocMarines()
        
        if nextDocTeamWaypontIndex >= 6 then
            docObjComplete = true
            GameWorld:ChangeObjectiveStatus("docObj", [[complete]])
        end
    end
    
end
ScriptMgr:SetUpdateCallback(PropCrateUpdateScript)

local sargeDead = false
local docDead = false
function NPCsAliveScriptUpdate(p_milliseconds)
    
    if sargeDead or docDead then
        return
    end
    
    if not sargeDead and not GameWorld:GetEntityById("sargeTeam1") then
        LevelUtils.ShowTimedDialogue("NO! They took down Drake.\n\nWhy the hell did I let him go?", "Scout")
        
        ScriptMgr:DoDelayedCall(5000,
            function()
                GameWorld:ClearText()
                GameWorld:GameOver(false) 
            end)
        
        sargeDead = true
    end
    
    if not docDead and not GameWorld:GetEntityById("docTeam1") then
        LevelUtils.ShowTimedDialogue("Hells, the Doc's dead!\n\nDamn it, I should have stayed to protect her.", "Sarge")
        
        ScriptMgr:DoDelayedCall(5000,
            function()
                GameWorld:ClearText()
                GameWorld:GameOver(false) 
            end)
        
        docDead = true
    end
    
end
ScriptMgr:SetUpdateCallback(NPCsAliveScriptUpdate)

wonAlready = false
sargeObjComplete = false
docObjComplete = false

function WinChecker(p_milliseconds)
    if sargeObjComplete and docObjComplete and not wonAlready then
        wonAlready = true

        GameWorld:ClearText()
        GameWorld:GameOver(true) 
    end
end
ScriptMgr:SetUpdateCallback(WinChecker)

function OnDocAttackTriggered()

    StartNextDocAttack()

    if nextSargeTeamWaypontIndex >= 6 then
        return
    end

    local timerleft = 90000
    local checkDelay = 500
    ScriptMgr:DoDelayedCall(checkDelay,
        function()
            
            if not sargeBusy then
                currentTimer = LevelUtils.CreateTimer(timerleft, "Next Sarge Attack in %s", function() GameWorld:SetEventIndicator(""); OnSargeAttackTriggered() end)
                CreatePathMarker("sargeTeam1", "sargeWaypoint" .. nextSargeTeamWaypontIndex)    
            else
                timerleft = math.max(timerleft - checkDelay, 3000)
            end
            
            return sargeBusy
            
        end)
    
end

function ReturnDocTeamToBase()
    for i=1, #docTeamIds do
        local offsetDelta = vect2f.MakePolar(GetRandomRangeInt(3.0, 4.0), i/#docTeamIds*math.pi*2)
        local entity = GameWorld:GetEntityById(docTeamIds[i])
        
        if entity then
        	local human = entity:ToCHuman()
        	
        	if human then
        		if i == 1 then
        			OrderMarineMove(docTeamIds[i], {"docWaypoint0"}, offsetDelta)
        		else
        			OrderMarineAssault(docTeamIds[i], {"docWaypoint0"}, offsetDelta)
        		end	
        	end
        end
    end    
end

docBusy = false

function StartNextDocAttack()

    local waypointId = "docWaypoint" .. nextDocTeamWaypontIndex
    local waypoint = GameWorld:GetEntityById(waypointId)

    if not waypoint then
        return
    end
    
    local crate = propCrateHandles[nextDocTeamWaypontIndex]:GetPtr()
    if not crate then
        return
    end
    
    GameWorld:MakeAnnouncement("DOCTOR\nATTACKING")
    docBusy = true
    
    for i=1, #docTeamIds do
        local offsetDelta = vect2f.MakePolar(GetRandomRangeInt(3.0, 4.0), i/#docTeamIds*math.pi*2)
        local entity = GameWorld:GetEntityById(docTeamIds[i])
        
        if entity then
        	local human = entity:ToCHuman()
        	
        	if human then
        		OrderMarineAssault(docTeamIds[i], {waypointId}, offsetDelta)
        		
        		if i == 1 then
        			human:SendCommand(ICommandable.CT_ACTIVATE, crate:GetPos() + offsetDelta, crate, true)
        			
        			GameWorld:CreateTrainingArrow(crate:GetId())
        			
                    trackingCrateHandle = crate:GetHandle()
                    trackingMarineHandle = human:GetHandle()
        		end	
        	end
        end
    end

    if nextDocTeamWaypontIndex == 1 then
        LevelUtils.ShowTimedDialogue("I thought that I could depend on you.\n\nGuess I will have to do this myself.", "Scout")
    elseif nextDocTeamWaypontIndex == 2 then
        LevelUtils.ShowTimedDialogue("It has copied ... humans?\n\nI need more data.", "Scout")
    elseif nextDocTeamWaypontIndex == 3 then
        LevelUtils.ShowTimedDialogue("This is bad - these clones are a major threat.\n\nWe need samples to develop weapons.", "Scout")
    elseif nextDocTeamWaypontIndex == 4 then
        LevelUtils.ShowTimedDialogue("Ok, I think that I have a plan.\n\nLet us wrap up here and regroup at base.", "Scout")
    elseif nextDocTeamWaypontIndex == 5 then
        LevelUtils.ShowTimedDialogue("Good riddance mercenary.\n\nI hope that your bank account is big enough to house your guilt.", "Scout")
    end

    nextDocTeamWaypontIndex = nextDocTeamWaypontIndex + 1
    
end


------------------------------------------------------------------------------- Capture Tracker (for sarge objective completion)
SargeMoveScript = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_RADIAL_MOVE_FINISHED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
        
        local marineId = "sargeTeam1"
        if p_entId ~= marineId then
            return
        end
        
        local marine = GameWorld:GetEntityById(marineId)
        if not marine then
            return
        end
        
        local waypointId = "sargeWaypoint" .. (nextSargeTeamWaypontIndex-1)
        local waypoint = GameWorld:GetEntityById(waypointId)
        if not waypoint then
            return
        end
        
        if not vect2f.IsDistLess(marine:GetPos(), waypoint:GetPos(), 10.0) then
            return
        end
        
        if nextSargeTeamWaypontIndex-1 == 5 then
            sargeObjComplete = true
            GameWorld:ChangeObjectiveStatus("sargeObj", [[complete]])
            LevelUtils.ShowTimedDialogue("Later Doc.\n\nYou really should get out of here while you can.", "Sarge")
        end
        
        sargeBusy = false        
        RemovePathMarker(waypointId)
        
	end)

SargeMoveScript:Enable()

